#ifndef WIN32

#ifndef DESKTOPSHARINGCONTROLLERIMPL_H
#define DESKTOPSHARINGCONTROLLERIMPL_H

#include "csfunified/framework/UnifiedFactory.h"
#include "csfunified/services/impl/base/DesktopSharingControllerBaseImpl.h"
#include "csfunified/services/interface/DSCallback.h"
#include "desktop_share_def.h"
#include "sdkwrapper/mac/MeetingSDKWrap.h"

namespace CSFUnified
{
    using namespace JM_SDK;
    
    class DesktopSharingControllerImpl: public DesktopSharingControllerBaseImpl, public IDSEvent
    {
    public:
        virtual ~DesktopSharingControllerImpl();
        static DesktopSharingControllerImpl * getInstance();
        
        // base impl
        void registerDSCallback(SMART_PTR_NS::shared_ptr<CSFUnified::DSCallback> dsCallback);
        void unregisterDSCallback(SMART_PTR_NS::shared_ptr<CSFUnified::DSCallback> dsCallback);
        bool isInSharing( );
        
        bool canStartSharing(std::string sessionName);
        bool startSharing(std::string sessionName);
        bool canJoinSharing(std::string sessionName);
        bool joinSharing(std::string sessionName);
        bool stopSharing( );
        bool reInviteCurSession();
        bool restartSharing( );
        bool changePresenter( );
        bool cancelSharing( );
        bool declineSharing(std::string sessionName);
        
        // IDSEvent
        void onPopupDSWaitingDialog();
        void onCloseDSWaitingDialog();
        void onDSStarted(const PString sessionName, bool isHost);
        void onDSEnded(const PString sessionName, bool isHost);
        void onDSError(const DS_ERROR_CODE errorCode, const PString sessionName);
        void onPopupChatWindow(const PString sessionName);
        void onMinimizeChatWindow(const PString sessionName);
        void onDSInvitation(const PString sessionName);
        void onDSDeclined(const PString sessionName);
        void onDSCancelled(const PString sessionName);
        void onSharingStopped(const PString sessionName);
        void onBuddyJoined();
        void onUserTryLeave(bool isHost);
        void onUserLeft();
        void onPresenterChanged();
        
        void start();
        void stop();
        
    private:
        DesktopSharingControllerImpl(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory);
        
        std::string getDSUrl();
        void getDSToken();
        void onDSTokenValueChanged();
        
        void reportDSUsage(std::wstring usageStr);
        
    private:
        SMART_PTR_NS::shared_ptr<UnifiedFactory> m_unifiedFactory;
        DSCallback* m_dsCallback;
        bool m_started;
        
        PropertyNotifierConnectionWPtr m_pDSTokenChanged;
        MeetingSDKWrap* m_pInstance;
        IDSMgr* m_pDSMgr;
        
        std::string m_strSessionName;
    };
    
}

#endif

#endif